<?php
// archivo: recibir_datos.php
header('Content-Type: application/json');

// Conexión a la base de datos (ajusta tus datos)
$host = "15.204.129.121";
$user = "liderplus";
$pass = "LiderPlus*2022";
$dbname = "erp_liderplus";

$mysqli = new mysqli($host, $user, $pass, $dbname);
if ($mysqli->connect_errno) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión a la base de datos"]);
    exit();
}

// Leer el JSON recibido
$inputJSON = file_get_contents('php://input');
$data = json_decode($inputJSON, true);

if (!$data) {
    http_response_code(400);
    echo json_encode(["error" => "JSON inválido o no recibido"]);
    exit();
}

// Función para escapar datos (prevenir SQL injection)
function escape($mysqli, $value) {
    return $mysqli->real_escape_string($value);
}

$respuesta = [
    "tpedidos" => 0,
    "tdetalles_pedido" => 0,
    "thistorial_gps" => 0,
    "tvisitas_empresa" => 0,
    "tdetalles_visita" => 0,
    "trecibos_ingreso" => 0,
    "tdetalles_recibo_ingreso" => 0,
    "tdetalles_finca_cambios" => 0,
    "errores" => []
];

// 1. Insertar pedidos y detalles
if (!empty($data["tpedidos"])) {
    foreach ($data["tpedidos"] as $pedido) {
        // Insert pedido
        $sql = "INSERT INTO tpedidos (cid_pedido, cid_clien, cnombre_cl, crif_cli, dfecha, cid_status, cid_vende, nmonto_t, ntasa_iva, nbase_iva, nmontoiva, nlatitud, nlongitud, nprecision, nhora_gps, cproveedor, ndias_p, cid_tipmo, cid_visi, cid_equipo) VALUES (
            '" . escape($mysqli, $pedido["cid_pedido"]) . "',
            '" . escape($mysqli, $pedido["cid_clien"]) . "',
            '" . escape($mysqli, trim($pedido["cnombre_cl"])) . "',
            '" . escape($mysqli, $pedido["crif_cli"]) . "',
            NOW(),
            '" . escape($mysqli, $pedido["cid_status"]) . "',
            '" . escape($mysqli, $pedido["cid_vende"]) . "',
            " . floatval($pedido["nmonto_t"]) . ",
            " . floatval($pedido["ntasa_iva"]) . ",
            " . floatval($pedido["nbase_iva"]) . ",
            " . floatval($pedido["nmontoiva"]) . ",
            " . floatval($pedido["nlatitud"]) . ",
            " . floatval($pedido["nlongitud"]) . ",
            " . floatval($pedido["nprecision"]) . ",
            " . intval($pedido["nhora_gps"]) . ",
            '" . escape($mysqli, $pedido["cproveedor"]) . "',
            " . intval($pedido["ndias_p"]) . ",
            '" . escape($mysqli, $pedido["cid_tipmo"]) . "',
            '" . escape($mysqli, $pedido["cid_visi"]) . "',
            '" . escape($mysqli, $pedido["cid_equipo"]) . "'
        )";

        if ($mysqli->query($sql)) {
            $respuesta["tpedidos"]++;
        } else {
            $respuesta["errores"][] = "tpedidos: " . $mysqli->error;
        }

        // Insertar detalles de pedido relacionados
        if (!empty($pedido["detalles"])) {
            foreach ($pedido["detalles"] as $detalle) {
                $sql_det = "INSERT INTO tdetalles_pedido (cid_pedido, cid_produc, ncantidad, nentregado, mobservaci, nprecio, nmonto) VALUES (
                    '" . escape($mysqli, $pedido["cid_pedido"]) . "',
                    '" . escape($mysqli, $detalle["cid_produc"]) . "',
                    " . floatval($detalle["ncantidad"]) . ",
                    0,
                    '" . escape($mysqli, trim($detalle["mobservaci"])) . "',
                    " . floatval($detalle["nprecio"]) . ",
                    " . floatval($detalle["nmonto"]) . "
                )";

                if ($mysqli->query($sql_det)) {
                    $respuesta["tdetalles_pedido"]++;
                } else {
                    $respuesta["errores"][] = "tdetalles_pedido: " . $mysqli->error;
                }
            }
        }
    }
}

// 2. Insertar historial gps
if (!empty($data["thistorial_gps"])) {
    foreach ($data["thistorial_gps"] as $gps) {
        $sql = "INSERT INTO thistorial_gps (cserial, nlongitud, nlatitud, nprecision, nhora_gps, cproveedor) VALUES (
            '" . escape($mysqli, $gps["cserial"]) . "',
            " . floatval($gps["nlongitud"]) . ",
            " . floatval($gps["nlatitud"]) . ",
            " . floatval($gps["nprecision"]) . ",
            " . intval($gps["nhora_gps"]) . ",
            '" . escape($mysqli, $gps["cproveedor"]) . "'
        )";

        if ($mysqli->query($sql)) {
            $respuesta["thistorial_gps"]++;
        } else {
            $respuesta["errores"][] = "thistorial_gps: " . $mysqli->error;
        }
    }
}

// 3. Insertar visitas y detalles
if (!empty($data["tvisitas_empresa"])) {
    foreach ($data["tvisitas_empresa"] as $visita) {
        $sql = "INSERT INTO tvisitas_empresa (cid_clien, cid_vende, dfecha_v, mobservaci, cid_status, lsincronizado, cid_finan, cnombreenv, cciclo, mlotes, mrecomen, cid_visi) VALUES (
            '" . escape($mysqli, $visita["cid_clien"]) . "',
            '" . escape($mysqli, $visita["cid_vende"]) . "',
            '" . escape($mysqli, $visita["dfecha_v"]) . "',
            '" . escape($mysqli, trim($visita["mobservaci"])) . "',
            '" . escape($mysqli, $visita["cid_status"]) . "',
            " . intval($visita["lsincronizado"]) . ",
            '" . escape($mysqli, $visita["cid_finan"]) . "',
            '" . escape($mysqli, $visita["cnombreenv"]) . "',
            '" . escape($mysqli, $visita["cciclo"]) . "',
            '" . escape($mysqli, $visita["mlotes"]) . "',
            '" . escape($mysqli, $visita["mrecomen"]) . "',
            '" . escape($mysqli, $visita["cid_visi"]) . "'
        )";

        if ($mysqli->query($sql)) {
            $respuesta["tvisitas_empresa"]++;
        } else {
            $respuesta["errores"][] = "tvisitas_empresa: " . $mysqli->error;
        }

        // Insertar detalles de visita relacionados
        if (!empty($visita["detalles"])) {
            foreach ($visita["detalles"] as $detalle) {
                $sql_det = "INSERT INTO tdetalles_visita (cid_visi, cid_produc, ncantidad, mobservaci, nprecio, nmonto, ndescuento) VALUES (
                    '" . escape($mysqli, $visita["cid_visi"]) . "',
                    '" . escape($mysqli, $detalle["cid_produc"]) . "',
                    " . floatval($detalle["ncantidad"]) . ",
                    '" . escape($mysqli, trim($detalle["mobservaci"])) . "',
                    " . floatval($detalle["nprecio"]) . ",
                    " . floatval($detalle["nmonto"]) . ",
                    " . floatval($detalle["ndescuento"]) . "
                )";

                if ($mysqli->query($sql_det)) {
                    $respuesta["tdetalles_visita"]++;
                } else {
                    $respuesta["errores"][] = "tdetalles_visita: " . $mysqli->error;
                }
            }
        }
    }
}

// 4. Insertar recibos y detalles
if (!empty($data["trecibos_ingreso"])) {
    foreach ($data["trecibos_ingreso"] as $recibo) {
        $sql = "INSERT INTO trecibos_ingreso (cid_reci_i, dfecha, cid_clien, cid_cobra, mobservaci, cid_status, nmonto) VALUES (
            '" . escape($mysqli, $recibo["cid_reci_i"]) . "',
            '" . escape($mysqli, $recibo["dfecha"]) . "',
            '" . escape($mysqli, $recibo["cid_clien"]) . "',
            '" . escape($mysqli, $recibo["cid_cobra"]) . "',
            '" . escape($mysqli, trim($recibo["mobservaci"])) . "',
            '" . escape($mysqli, $recibo["cid_status"]) . "',
            " . floatval($recibo["nmonto"]) . "
        )";

        if ($mysqli->query($sql)) {
            $respuesta["trecibos_ingreso"]++;
        } else {
            $respuesta["errores"][] = "trecibos_ingreso: " . $mysqli->error;
        }

        // Insertar detalles recibo ingreso
        if (!empty($recibo["detalles"])) {
            foreach ($recibo["detalles"] as $detalle) {
                $sql_det = "INSERT INTO tdetalles_recibo_ingreso (cid_clien, cid_docum, cid_tipo_a, cid_tipo_d, creferenci, ctipo, dfecha, mobservaci, nmonto_d, nmonto_h, nsaldo, cdoc_ref) VALUES (
                    '" . escape($mysqli, $detalle["cid_clien"]) . "',
                    '" . escape($mysqli, $detalle["cid_docum"]) . "',
                    '" . escape($mysqli, $detalle["cid_tipo_a"]) . "',
                    '" . escape($mysqli, $detalle["cid_tipo_d"]) . "',
                    '" . escape($mysqli, $detalle["creferenci"]) . "',
                    '" . escape($mysqli, $detalle["ctipo"]) . "',
                    '" . escape($mysqli, $detalle["dfecha"]) . "',
                    '" . escape($mysqli, trim($detalle["mobservaci"])) . "',
                    " . floatval($detalle["nmonto_d"]) . ",
                    " . floatval($detalle["nmonto_h"]) . ",
                    " . floatval($detalle["nsaldo"]) . ",
                    '" . escape($mysqli, $detalle["cdoc_ref"]) . "'
                )";

                if ($mysqli->query($sql_det)) {
                    $respuesta["tdetalles_recibo_ingreso"]++;
                } else {
                    $respuesta["errores"][] = "tdetalles_recibo_ingreso: " . $mysqli->error;
                }
            }
        }
    }
}

// 5. Insertar detalles finca cambios
if (!empty($data["tdetalles_finca_cambios"])) {
    foreach ($data["tdetalles_finca_cambios"] as $finca) {
        $sql = "INSERT INTO tdetalles_finca_cambios (cid_finan, cnombreenv, cid_lote, ncant_se, ncant_fi, ncant_si, ncant_pr, cid_status, mobservaci, dfechacambio, cid_visita) VALUES (
            '" . escape($mysqli, $finca["cid_finan"]) . "',
            '" . escape($mysqli, $finca["cnombreenv"]) . "',
            '" . escape($mysqli, $finca["cid_lote"]) . "',
            " . floatval($finca["ncant_se"]) . ",
            " . floatval($finca["ncant_fi"]) . ",
            " . floatval($finca["ncant_si"]) . ",
            " . floatval($finca["ncant_pr"]) . ",
            '" . escape($mysqli, $finca["cid_status"]) . "',
            '" . escape($mysqli, $finca["mobservaci"]) . "',
            '" . escape($mysqli, $finca["dfechacambio"]) . "',
            '" . escape($mysqli, $finca["cid_visita"]) . "'
        )";

        if ($mysqli->query($sql)) {
            $respuesta["tdetalles_finca_cambios"]++;
        } else {
            $respuesta["errores"][] = "tdetalles_finca_cambios: " . $mysqli->error;
        }
    }
}

echo json_encode($respuesta);

$mysqli->close();
?>
